import sys, glob
# path for file generated by Apache Thrift Compiler
sys.path.append('gen-py')
# add path where built Apache Thrift libraries are
sys.path.insert(0, glob.glob('thrift-0.9.2/lib/py/build/lib.*')[0])

import re, sre_constants
from math import sin, cos, acos, ceil, radians

from mytoolbox import MyToolbox
from mytoolbox.ttypes import *
from mytoolbox.constants import *
from mybase.ttypes import *
from mybase.constants import *

from thrift.transport import TSocket
from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol
from thrift.server import TServer

# add logging
import logging
logger = logging.getLogger('thrift.server.TServer')
logger.setLevel(logging.DEBUG)
ch = logging.StreamHandler()
ch.setLevel(logging.DEBUG)
logger.addHandler(ch)

# purely the convention, not requirement
class MyBaseHandler(object):
    
    def __init__(self):
        pass

    def save_to_log(self, message, filename):
        if len(message) < 5:
            raise MessageTooShort(description="The message is too short.")

        if re.search('/[^a-z1-9\.]/', filename, re.IGNORECASE) is not None:
            raise InvalidFileName(description="The filename contains forbidden characters.")

        try:
            with open(filename, 'a') as file:
                file.write(message + '\n')
        except IOError as error:
            raise CantWriteToFile(description="I/O error({0}): {1}".format(error.errno, error.strerror))
        except:
            raise CantWriteToFile(description="Unknown error while writing to file %s." % filename)


class MyToolboxHandler(MyBaseHandler):

    def __init__(self):
        pass

    def get_distance(self, point1, point2):
        
        if not isinstance(point1, Point):
            raise WrongDataType(description="point1 is of wrong type.")

        if not isinstance(point2, Point):
            raise WrongDataType(description="point2 is of wrong type.")

        if \
               point1.latitude < -180 \
            or point1.latitude > 180  \
            or point1.longitude < -90 \
            or point1.longitude > 90:
                raise CoordsOutOfRange(description="Coordinates of point1 are out of range.")

        if \
               point2.latitude < -180 \
            or point2.latitude > 180  \
            or point2.longitude < -90 \
            or point2.longitude > 90:
                raise CoordsOutOfRange(description="Coordinates of point2 are out of range.")

        return \
            ceil(EARTH_RADIUS * \
            acos(
                sin(radians(point1.latitude)) * sin(radians(point2.latitude))
                + cos(radians(point1.latitude)) * cos(radians(point2.latitude)) * cos(radians(abs(point1.longitude - point2.longitude)))
            ))

    def find_occurences(self, string_to_match, regex):

        try:
            return re.findall(regex, string_to_match)
        except sre_constants.error:
            raise NoValidRegex(description="Provided regular expression '%s' is invalid." % regex)
        except TypeError:
            raise InvalidInputString(description="Cannot parse the string to match.")


port = 8080    

handler = MyToolboxHandler()
processor = MyToolbox.Processor(handler)
transport = TSocket.TServerSocket(port=port)
tfactory = TTransport.TBufferedTransportFactory()
pfactory = TBinaryProtocol.TBinaryProtocolFactory()

server = TServer.TSimpleServer(processor, transport, tfactory, pfactory)

print "Starting server on port %d" % port
server.serve()
